#version 430



vec4 rotateXZ(vec4 p, float a) {
vec4 r = p;
r.x = cos(a)*p.x - sin(a)*p.z;
r.z = sin(a)*p.x + cos(a)*p.z;
return r;
}

vec3 rotateXZ3(vec3 p, float a) {
return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
vec4 r = p;
r.x = cos(a)*p.x - sin(a)*p.y;
r.y = sin(a)*p.x + cos(a)*p.y;
return r;
}


vec3 rotateXY(vec3 p, float a) {
vec3 r = p;
r.x = cos(a)*p.x - sin(a)*p.y;
r.y = sin(a)*p.x + cos(a)*p.y;
return r;
}


vec4 rotateYZ(vec4 p, float a) {
vec4 r = p;
r.y = cos(a)*p.y - sin(a)*p.z;
r.z = sin(a)*p.y + cos(a)*p.z;
return r;
}

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


layout(points) in;
layout(points) out;
layout(max_vertices = 2) out;

//layout(line_strip, max_vertices = 15) out;

in vec3 posV[];
in vec2 uvV[];
in vec3 velV[];
in float ageV[];
in float recV[];
in float ageSplitV[];
in vec4 posInitV[];
// in vec4 posScrV[];


out vec3 posG;
out vec2 uvG;
out vec3 velG;
out float ageG;
out float recG;
out float ageSplitG;
out vec4 posInitG;
// out vec4 posScrG;

uniform float g_force = 1.0;
uniform float g_noiseFreq = 1.0;
uniform float g_speed = 1.0;
uniform float g_initShapeX = 1.0;
uniform float g_initShapeY = 1.0;
uniform float g_maxAge = 10.0;

uniform float g_initPosX = 0.0;
uniform float g_initPosY = 0.0;
uniform float g_initPosZ = 0.0;

uniform vec4 g_noiseScale = vec4(1.0, 5.0, 1.0, 0.0);

uniform float g_velDamping = 1.0;
uniform float g_emitShape = 0.0;


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform mat4 projectionInvMatrix;
uniform mat4 modelViewInvMatrix;

uniform float g_time;
uniform float g_timeStep;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNoise;
layout(binding=2) uniform sampler2D texEmitShape;
layout(binding=3) uniform sampler2D texDepth;

uniform float g_pikselos = 0.0;
in int gl_PrimitiveID;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;

uniform float g_elasticity = 0.5;

//// from Iq: http://www.iquilezles.org/www/articles/texture/texture.htm
//vec4 getTexel( sampler2D s, vec2 p ) {
//    //return texture2D(s, p);

//    highp vec2 texRes = vec2(g_windowWidth, g_windowHeight);
//    p = p*texRes+0.5;

//    highp vec2 i = floor(p);
//    highp vec2 f = p - i;
//    f = f*f*f*(f*(f*6.0-15.0)+10.0);
//    p = i + f;

//    p = (p - 0.5)/texRes;
//    return texture2D(s, p);
//}

uniform float zNear = 0.1;
uniform float zFar = 1000.0;
// convert from 0.0 to 1.0 depth sample ds to linear depth
float linearDepth(float ds) {
    ds = 2.0*ds-1.0;
    float zLinear = 2.0*zNear*zFar/(zFar+zNear-ds*(zFar-zNear));
    return zLinear;
}
// result suitable for assigning to gl_FragDepth
float depthSample(float linearDepth) {
    float nonLinearDepth = (zFar+zNear-2.0*zNear*zFar/linearDepth)/(zFar-zNear);
    nonLinearDepth = (nonLinearDepth+1.0)/2.0;
    return nonLinearDepth;
}

float noise(in vec3 x) //3d noise from iq
{
    vec3 p = floor(x);
    vec3 f = fract(x);
        f = f*f*(3.0-2.0*f);
        vec2 uv = (p.xy+vec2(37.0,17.0)*p.z) + f.xy;
        vec2 rg = texture2D( texNoise, (uv+ 0.5)/256.0 ).yx;
        return mix( rg.x, rg.y, f.z )-0.50;
}

float fbm(in vec3 x)
{
    float rz = 0.0;
    float a = 0.350;
    for (int i = 0; i<4; i++)
    {
        rz += noise(x)*a;
        a*=.5;
        x*= 4.;
    }
    return rz;
}


float fbmm(in vec3 x)
{
    float rz = 1.0;
    float a = 2.0;
    for (int i = 0; i<4; i++)
    {
        rz *= noise(x)*a;
        a*=.95;
        x*= 2.;
    }
    return rz;
}

uniform float g_gridDim = 100.0;
uniform float g_rotOrigin = 0.0;

uniform vec4 g_noiseOfs = vec4(0.0, 0.0, 0.0, 0.0);


void main(void) {

    vec3 pos = posV[0];
    vec2 uv = uvV[0];

    vec3 vel = velV[0];
    float age = ageV[0];
    float rec = recV[0];

    float ageSplit = ageSplitV[0];

    vec4 pI = posInitV[0];



    vec3 posInit = vec3(0.0);


    mat4 mvp = projectionMatrix * modelViewMatrix;

   // mat4 mvp = projectionMatrix * modelViewMatrix;
    vec3 posNois = vec3(0.0);
    float tkk = 1.1;

    float distFromOrig = dot(pos,pos);


    float simSpeed = 1.0;

    float myTime = g_time*0.10*simSpeed;
    float myTimeStep = g_timeStep*simSpeed;
    float k = 1.0;

    bool bInited = age>0.0001;

    int prim = gl_PrimitiveID;

    if (!bInited || distFromOrig>200.0 || age>g_maxAge) { // init particle

        int gridDim = int(g_gridDim);

        int primZ = 0;
        int primY = int(prim/gridDim);
        int primX = prim-primY*gridDim;

        float pullaU = float(primX)/float(gridDim);
        float pullaV = float(primY)/float(gridDim);

        if (rec > 0.5) { // do not re-init recursed particle
          return;
        }

        rec = 0.0;

        if (age < 0.0001 && prim!=0) {
        // first time age is zero when we come to init
            posInit.x = (pullaU-0.5);
            posInit.z = (pullaV-0.5);
            posInit.y = 0.0;

            pos.y = (pullaU-0.5)*2.0*g_initShapeX+g_initPosX;
            pos.z = (pullaV-0.5)*2.0*g_initShapeY+g_initPosZ;
            pos.x = 0.0*2.0+g_initPosY;

            uv.x = pullaU*1.0+0.0;
            uv.y = pullaV*1.0+0.0;

            ageSplit = g_maxAge-rand(pos.xy)*g_maxAge;

            age = rand(pos.yz)*2.0*g_maxAge;

            if (g_emitShape == 1) {
                pos.x = 1.0*sin(prim*0.01+myTime);
                pos.y = 1.0*cos(pos.x*1.4*sin(prim*0.01)+myTime);
                pos.z = 1.0*cos(pos.y*1.2*cos(pos.x*2.4)+myTime);
            }

        } else {
            if (g_emitShape == 0) {

                posInit.x = (pullaU-0.5);
                posInit.z = (pullaV-0.5);
                posInit.y = 0.0;

                pos.x = posInit.x*2.0*g_initShapeX+g_initPosX;
                pos.y = posInit.y*2.0+g_initPosY;
                pos.z = posInit.z*2.0*g_initShapeY+g_initPosZ;
            } else {
                pos.x = 1.0*sin(prim*0.01+myTime);
                pos.y = 1.0*cos(pos.x*1.4*sin(prim*0.01)+myTime);
                pos.z = 1.0*cos(pos.y*1.2*cos(pos.x*2.4)+myTime);
            }
            age = 0.01; //+(rand(pos.xy))*g_maxAge;
        }

        vel = vec3(0.0);


    }


   // pos.xyz = rotateXY(pos.xyz, -g_timeStep*distFromOrig*g_rotOrigin);

    vec4 pos4 = vec4(pos, 1.0);
    pos4.w = 1.0;
    vec4 posScreen = mvp*pos4;
    vec2 scrTexPos = posScreen.xy/posScreen.w*0.5+vec2(0.5, 0.5);
    float da = posScreen.z/posScreen.w;
    vec4 dd = texture2D(texDepth, scrTexPos);

    da = linearDepth(da);
    dd.r = linearDepth(dd.r);


    if (!(scrTexPos.x>=0.0 && scrTexPos.y>=0.0 && scrTexPos.x<1.0 && scrTexPos.y<1.0)) {
       // age += g_timeStep*10.0;
    }


    int split = 0;

    vec3 rNormal;

    float velRefl = 0.0;


    float difo = dd.r-da;
    if (abs(difo) < 0.5 && (scrTexPos.x>=0 && scrTexPos.y>=0 && scrTexPos.x<1.0 && scrTexPos.y<1.0)) {
       vec3 nextPos = pos+vel*myTimeStep*g_speed*1.0;
       vec4 np4 = vec4(nextPos, 1.0);
       np4.w = 1.0;
       vec4 nps = mvp*np4;

       vec2 nscrTexPos = nps.xy/nps.w*0.5+vec2(0.5, 0.5);
       vec4 ndd = texture2D(texDepth, nscrTexPos);
       float nda = nps.z/nps.w;

        nda = linearDepth(nda);
        ndd.r = linearDepth(ndd.r);


       float ndifo = ndd.r-nda;



       // vel = vec3(0.0);
       if (abs(ndifo) < abs(difo)-0.00) {

        vec3 ssNormal = vec3(dd.gb, 0.0);
        ssNormal.z = sqrt(1.0-dot(ssNormal.xy, ssNormal.xy));

        // uniform mat4 projectionInvMatrix;
        // uniform mat4 modelViewInvMatrix;

        ssNormal = normalize(ssNormal);
        vec4 wsNormal = vec4(ssNormal, 1.0);

       // wsNormal = wsNormal*modelViewInvMatrix;
       // wsNormal = modelViewInvMatrix*wsNormal;

        float elasticity = g_elasticity;

        float colvel = sqrt(dot(vel,vel));

        if (colvel > 2.0 && rec < 6.0) {
       //   if (rec < 0.5 || rec > 1.5) {
       //           rec += 1.0;
       //   }
          split = 1;
        }

         //k = 0.0;
        // vel = -vel*(1.0+1.0);
        vec3 vr = reflect(vel, -wsNormal.xyz);

        rNormal = wsNormal.xyz;
        // vec3 vr = reflect(vel*1.0, vec3(0.0, 1.0, 0.0));
        vel = (vr+vel)*0.5+(vr-(vr+vel)*0.5)*(elasticity);

        velRefl = sqrt(dot(vel,vel));
       // vel += vr*0.05;
       // vel = vr*elasticity;
        pos += vr*myTimeStep*g_speed*0.0;
        //k = 0;
       }
    }

   // vel = vec3(0.0, -1.0, 0.0);


    age += g_speed*myTimeStep*(1.0+rand(vec2(gl_PrimitiveID*0.2, gl_PrimitiveID*2.13)));
    pos += vel*myTimeStep*g_speed;
    float bScale = 2.4;

    vec2 myUv = uv;
    myUv.y = -myUv.y;
    myUv.x = myUv.x;

    vec4 emitShape = texture2D(texEmitShape, myUv);

//    if (emitShape.r < 0.1 ) {
//        return;
//    }

   // rec = emitShape.r*3.0;

    myTime = g_time*1.0*simSpeed;
    float timeStepScale = 2.2;

/*
    posNois.x += cos(myTime*tkk+bScale*pos.y*(2.2+2.0*sin(myTime))*sin(g_time*tkk*1.2+pos.y*10.3));
    posNois.y += sin(myTime*tkk*1.23-bScale*pos.x*(2.2+2.0*cos(0.3+myTime*0.7))*cos(myTime*tkk*0.912+pos.x*10.3));
    posNois.z += 2.5*sin(myTime*tkk*1.63-bScale*pos.y*(1.2+1.0*sin(0.45+myTime*0.32))*cos(myTime*tkk*1.312+pos.y*12.3-pos.z*10.3));
    */

    float noiseFreq = g_noiseFreq;
    posNois.x = fbm(pos.xyz*0.230*noiseFreq+0.1*vec3(myTime, myTime*1.2, 0.3));
    posNois.y = fbm(pos.yzx*0.30*noiseFreq+0.1*vec3(myTime*0.3, myTime*0.62, 0.3));
    posNois.z = fbm(pos.zyx*0.20*noiseFreq+0.1*vec3(myTime*0.1, myTime*0.12, 0.3));
    posNois.xyz *= g_noiseScale.xyz;

    posNois += g_noiseOfs.xyz;

//    posNois.y += fbm(posNois.xzy*1.50*noiseFreq+0.0*vec3(g_time*0.3, g_time*0.62, 0.3));
//    posNois.z += fbm(posNois.zyx*1.20*noiseFreq+0.0*vec3(g_time*0.1, g_time*0.12, 0.3));
//    posNois.x += fbm(posNois.xyz*1.230*noiseFreq+0.0*vec3(g_time, g_time*1.2, 0.3));

//    vec4 result = texture2D(texNoise, uvNois*0.10+vec2(0.0, 0.0));

//    pos.x += 0.1*sin(pos.y*24.4+myTime)*0.1;
//    pos.y += 0.1*cos(pos.y*24.2*sin(pos.x*23.4)+myTime)*0.1;
//    pos.z += 0.005*cos(pos.y*11.2*cos(pos.x*12.4)+myTime)*0.1;

   // posNois.y -= 0.005;

    vel.xyz += g_force*myTimeStep*posNois.xyz*timeStepScale*k; // (0.2+0.15*sin(g_time*1.0));

    vel.xyz *= (1.0-myTimeStep*g_velDamping);

//    pos.xy += noiseValue.xy*1.1;

//    pos.z += abs(0.10*(result.r*1.0-0.5)*0.20);
//    pos.x += 0.0*(result.g*1.0-0.5)*0.20;
//    pos.y += 0.0*(result.b*1.0-0.5)*0.20;

//    pos.z += 0.0003;

//    float maxZ = 0.02;

//    if (pos.z > maxZ) {
//        pos.z = -maxZ;
//    }
// vec4 result = texture2D(tex, uv[0]+vec2(0.0, 0.0));

    //pos.x += 10.0*sin(g_time);
    //pos.y += 10.0*cos(g_time);

    pos4 = vec4(pos, 1.0);
   // pos4.w = 1.0;
    posScreen = mvp*pos4;

    pI = posScreen;


//    pI = wsNormal;

    posG = pos;
    uvG = uv;
    velG = vel;
    ageG = age;
    recG = rec;
    ageSplitG = ageSplit;
    posInitG = pI;
    EmitVertex();


    if (split == 1 && rec < 0.5) {
        for (int i=0; i<12; i++) {
            posG = pos;
            uvG = uv;
            velG += 20.0*vec3(fbm(pos*(i+0.2)*23.0), 0.0+fbm(pos*(i*0.2+0.2)*10.80+vec3(g_time, 0.0, g_time*0.01)), noise(pos*(i*0.4+0.1)*32.12+vec3(g_time*0.34, 0.0, g_time*0.71)));
            velG += rNormal*6.0;
            //velG = normalize(velG)*velRefl;
            ageG = age;
            recG = 1.0;
            ageSplitG = ageSplit;
            posInitG = pI;
            EmitVertex();
        }
    }

//    posG = pos;
//    uvG = uv;
//    velG = vel;
//    ageG = age;
//    recG = rec;
//    ageSplitG = ageSplit;
//    posInitG = posInit;
//    EmitVertex();

    EndPrimitive();
}
